/*
 * Decompiled with CFR 0.152.
 */
package me.codexadrian.tempad;

import dev.architectury.injectables.annotations.ExpectPlatform;
import java.io.IOException;
import java.util.List;
import me.codexadrian.tempad.TempadClientConfig;
import me.codexadrian.tempad.client.gui.TempadScreen;
import me.codexadrian.tempad.forge.TempadClientImpl;
import me.codexadrian.tempad.items.TempadItem;
import me.codexadrian.tempad.platform.Services;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.item.ClampedItemPropertyFunction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;

public class TempadClient {
    private static TempadClientConfig clientConfig;
    private static final List<String> incompatibleMods;

    public static void init() {
        ClampedItemPropertyFunction clampedItemPropertyFunction = (itemStack, clientLevel, livingEntity, i) -> {
            if (livingEntity instanceof Player) {
                Player player = (Player)livingEntity;
                Item patt1067$temp = itemStack.m_41720_();
                if (patt1067$temp instanceof TempadItem) {
                    TempadItem tempad = (TempadItem)patt1067$temp;
                    return tempad.getOption().canTimedoorOpen(player, itemStack) ? 1.0f : 0.0f;
                }
            }
            return 0.0f;
        };
        TempadClient.registerItemProperty(Services.REGISTRY.getItem(), new ResourceLocation("usable"), clampedItemPropertyFunction);
        TempadClient.registerItemProperty(Services.REGISTRY.getCreativeItem(), new ResourceLocation("usable"), clampedItemPropertyFunction);
        try {
            clientConfig = TempadClientConfig.loadConfig(Services.PLATFORM.getConfigDir());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static TempadClientConfig getClientConfig() {
        return clientConfig;
    }

    public static void openScreen(InteractionHand interactionHand) {
        int color = TempadClient.getClientConfig().getColor();
        Minecraft.m_91087_().m_91152_((Screen)new TempadScreen(color, interactionHand));
    }

    public static boolean isIncompatibleModLoaded() {
        return incompatibleMods.stream().anyMatch(Services.PLATFORM::isModLoaded);
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static void registerItemProperty(Item pItem, ResourceLocation pName, ClampedItemPropertyFunction pProperty) {
        void var2_2;
        void var1_1;
        TempadClientImpl.registerItemProperty(pItem, (ResourceLocation)var1_1, (ClampedItemPropertyFunction)var2_2);
    }

    static {
        incompatibleMods = List.of("flywheel", "imm_ptl_core", "structurize", "mahou");
    }
}

